'\" t
.TH @g@grn @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
@g@grn \- embed Gremlin images in
.I groff
documents
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 2000-2024 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_grn_1_man_C \n[.cp]
.cp 0
.
.\" Define fallback for groff 1.23's MR macro if the system lacks it.
.nr do-fallback 0
.if !\n(.f           .nr do-fallback 1 \" mandoc
.if  \n(.g .if !d MR .nr do-fallback 1 \" older groff
.if !\n(.g           .nr do-fallback 1 \" non-groff *roff
.if \n[do-fallback]  \{\
.  de MR
.    ie \\n(.$=1 \
.      I \%\\$1
.    el \
.      IR \%\\$1 (\\$2)\\$3
.  .
.\}
.rr do-fallback
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY @g@grn
.RB [ \-C ]
.RB [ \-T\~\c
.IR dev ]
.RB [ \-M\~\c
.IR dir ]
.RB [ \-F\~\c
.IR dir ]
.RI [ file\~ .\|.\|.]
.YS
.
.
.P
.SY @g@grn
.B \-?
.YS
.
.SY @g@grn
.B \-\-help
.YS
.
.
.P
.SY @g@grn
.B \-v
.YS
.
.SY @g@grn
.B \%\-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
.I @g@grn
is a preprocessor for including
.I gremlin
pictures in
.MR @g@troff @MAN1EXT@
input.
.
.I @g@grn
writes to standard output,
processing only input lines between two that start with
.B .GS
and
.BR .GE .
.
Those lines must contain
.I @g@grn
commands
(see below).
.
These macros request a
.I gremlin
file;
the picture in that file is converted and placed in the
.I @g@troff
input stream.
.
.B .GS
may be called with a
.BR C ,
.BR L ,
or
.B R
argument to center,
left-,
or right-align the whole
.I gremlin
picture
(the default is to center).
.
If no
.I file
is mentioned,
the standard input is read.
.
At the end of the picture,
the position on the page is the bottom of the
.I gremlin
picture.
.
If the
.I @g@grn
entry is ended with
.B .GF
instead of
.BR .GE ,
the position is left at the top of the picture.
.
.
.PP
Currently only the
.I me
macro package has support for
.BR .GS ,
.BR .GE ,
and
.BR .GF .
.
.
.PP
.I @g@grn
produces drawing escape sequences that use
.IR groff 's
color scheme extension
.RB ( \[rs]D\[aq]F \~.\|.\|.\& \[aq] ),
and thus may not work with other
.IR troff s.
.
.
.\" ====================================================================
.SS "\f[I]grn\f[] commands"
.\" ====================================================================
.
Each input line between
.B .GS
and
.B .GE
may have one
.I @g@grn
command.
.
Commands consist of one or two strings separated by whitespace,
the first string being the command and the second its operand.
.
Commands may be upper- or lowercase and abbreviated down to one
character.
.
.
.PP
Commands that affect a picture's environment
(those listed before
.RB \%\[lq] default \[rq],
see below)
are only in effect for the current picture:
the environment is reinitialized to the defaults at the start of the
next picture.
.
The commands are as follows.
.
.
.TP
.BI 1\~ N
.TQ
.BI 2\~ N
.TQ
.BI 3\~ N
.TQ
.BI 4\~ N
.
Set
.IR gremlin 's
text size number 1
(2,
3,
or 4)
to
.I N
points.
.
The default is 12
(16,
24,
and 36,
respectively).
.
.
.TP
.BI roman\~ f
.TQ
.BI italics\~ f
.TQ
.BI bold\~ f
.TQ
.BI special\~ f
Set the roman
(italics,
bold,
or special)
font to
.IR @g@troff 's
font
.I f
(either a name or number).
.
The default is R
(I,
B,
and S,
respectively).
.
.
.TP
.BI l\~ f
.TQ
.BI stipple\~ f
Set the stipple font to
.IR @g@troff 's
stipple font
.I f
(name or number).
.
The command
.B \%stipple
may be abbreviated down as far as
.RB \[lq] st \[rq]
(to avoid confusion with
.RB \%\[lq] special \[rq]).
.
There is
.I no
default for stipples
(unless one is set by the
.RB \%\[lq] default \[rq]
command),
and it is invalid to include a
.I gremlin
picture with polygons without specifying a stipple font.
.
.
.TP
.BI x\~ N
.TQ
.BI scale\~ N
Magnify the picture
(in addition to any default magnification)
by
.IR N ,
a floating-point number larger than zero.
.
The command
.B scale
may be abbreviated down to
.RB \[lq] sc \[rq].
.
.
.TP
.BI narrow\~ N
.TQ
.BI medium\~ N
.TQ
.BI thick\~ N
.
Set the thickness of
.IR gremlin 's
narrow
(medium and thick,
respectively)
lines to
.I N
times 0.15pt
(this value can be changed at compile time).
.
The default is 1.0
(3.0 and 5.0,
respectively),
which corresponds to 0.15pt
(0.45pt and 0.75pt,
respectively).
.
A thickness value of zero selects the smallest available line thickness.
.
Negative values cause the line thickness to be proportional to the
current point size.
.
.
.TP
.BR pointscale\~ [ off | on ]
Scale text to match the picture.
.
Gremlin text is usually printed in the point size specified with the
commands
.BR 1 ,
.BR 2 ,
.BR 3 ,
.RB or\~ 4 ,
regardless of any scaling factors in the picture.
.
Setting
.B pointscale
will cause the point sizes to scale with the picture
(within
.IR @g@troff 's
limitations,
of course).
.
An operand of anything but
.B off
will turn text scaling on.
.
.
.TP
.B default
Reset the picture environment defaults to the settings in the current
picture.
.
This is meant to be used as a global parameter setting mechanism at
the beginning of the
.I @g@troff
input,
but can be used at any time to reset the default settings.
.
.
.TP
.BI width\~ N
Force the picture to be
.I N
inches wide.
.
This overrides any scaling factors present in the same picture.
.
.RB \[lq] "width 0" \[rq]
is ignored.
.
.
.TP
.BI height\~ N
Force the picture to be
.I N
inches high,
overriding other scaling factors.
.
If both
.B width
and
.B height
are specified,
the tighter constraint will determine the scale of the picture.
.
.B height
and
.B width
commands are not saved with a
.RB \%\[lq] default \[rq]
command.
.
They will,
however,
affect point size scaling if that option is set.
.
.
.TP
.BI file\~ name
Get picture from
.I gremlin
file
.I name
located the current directory
(or in the library directory;
see the
.B \-M
option above).
.
If multiple
.B file
commands are given,
the last one controls.
.
If
.I name
doesn't exist,
an error message is reported and processing continues from the
.B .GE
line.
.
.
.\" ====================================================================
.SS "Usage with \f[I]groff\f[]"
.\" ====================================================================
.
Since
.I @g@grn
is a preprocessor,
it has no access to elements of formatter state,
such as
indentation,
line length,
type size,
or
register values.
.
Consequently,
no
.I @g@troff
input can be placed between the
.B .GS
and
.B .GE
macros.
.
However,
.I gremlin
text elements are subsequently processed by
.IR @g@troff ,
so anything valid in a single line of
.I @g@troff
input is valid in a line of
.I gremlin
text
(barring the dot control character \[lq].\[rq] at the beginning of a
line).
.
Thus,
it is possible to have equations within a
.I gremlin
figure by including in the
.I gremlin
file
.I eqn \" language
expressions enclosed by previously defined delimiters
(e.g.,
\[lq]$$\[rq]).
.
.
.PP
When using
.I @g@grn
along with other preprocessors,
run
.MR @g@tbl @MAN1EXT@
before
.IR @g@grn ,
.MR @g@pic @MAN1EXT@ ,
and/or
.IR ideal . \" no GNU version yet
.
If
.MR @g@eqn @MAN1EXT@
is needed,
run it as the last preprocessor.
.
.MR groff @MAN1EXT@
automatically runs preprocessors in the correct order.
.
.
.PP
A picture is considered an entity,
but that doesn't stop
.I @g@troff
from trying to break it up if it falls off the end of a page.
.
Placing the picture between \[lq]keeps\[rq] in the
.I me
macros will ensure proper placement.
.
.
.PP
.I @g@grn
uses
.IR @g@troff 's
registers
.B g1
through
.B g9
and sets registers
.B g1
and
.B g2
to the width and height of the
.I gremlin
figure
(in device units)
before entering the
.B .GS
macro
(this is for those who want to rewrite these macros).
.
.
.\" ====================================================================
.SS "Gremlin file format"
.\" ====================================================================
.
There exist two distinct
.I gremlin
file formats:
the original format for AED graphic terminals,
and the Sun or X11 version.
.
An extension used by the Sun/X11 version allowing reference points with
negative coordinates is
.I not
compatible with the AED version.
.
As long as a
.I gremlin
file does not contain negative coordinates,
either format will be read correctly by either version of
.I gremlin
or
.IR @g@grn .
.
The other difference in
Sun/X11 format is the use of names for picture objects
(e.g.,
.BR POLYGON ,
.BR CURVE )
instead of numbers.
.
Files representing the same picture are shown below.
.
.
.PP
.EX
.ie t .ne 18v
.el   .ne 19v
.TS
center, tab(@);
l lw(0.1i) l.
sungremlinfile@@gremlinfile
0 240.00 128.00@@0 240.00 128.00
CENTCENT@@2
240.00 128.00@@240.00 128.00
185.00 120.00@@185.00 120.00
240.00 120.00@@240.00 120.00
296.00 120.00@@296.00 120.00
*@@\-1.00 \-1.00
2 3@@2 3
10 A Triangle@@10 A Triangle
POLYGON@@6
224.00 416.00@@224.00 416.00
96.00 160.00@@96.00 160.00
384.00 160.00@@384.00 160.00
*@@\-1.00 \-1.00
5 1@@5 1
0@@0
\-1@@\-1
.TE
.EE
.
.
.IP \[bu] 3n
The first line of each
.I gremlin
file contains either the string
.RB \%\[lq] gremlinfile \[rq]
(AED)
or
.RB \%\[lq] sungremlinfile \[rq]
(Sun/X11).
.
.
.IP \[bu]
The second line of the file contains an orientation and
.I x
and
.I y
values for a positioning point,
separated by spaces.
.
The orientation,
either
.B 0
or
.BR 1 ,
is ignored by the Sun/X11 version.
.
.B 0
means that
.I gremlin
will display things in horizontal format
(a drawing area wider than it is tall,
with a menu across the top).
.
.B 1
means that
.I gremlin
will display things in vertical format
(a drawing area taller than it is wide,
with a menu on the left side).
.
.I x
and
.I y
are floating-point values giving a positioning point to be used when
this file is read into another file.
.
The stuff on this line really isn't all that important;
a value of
.RB \[lq] "1 0.00 0.00" \[rq]
is suggested.
.
.
.IP \[bu]
The rest of the file consists of zero or more element specifications.
.
After the last element specification is a line containing the string
.RB \[lq] \-1 \[rq].
.
.
.IP \[bu]
Lines longer than 127 characters are truncated to that length.
.
.
.\" ====================================================================
.SS "Element specifications"
.\" ====================================================================
.
.IP \[bu] 3n
The first line of each element contains a single decimal number giving
the type of the element (AED) or its name (Sun/X11).
.
.
.IP
.ie t .ne 18v
.el   .ne 19v
.TS
center, tab(@);
css
ccc
nBlBl.
\f[I]gremlin\f[] File Format: Object Type Specification
_
AED Number@Sun/X11 Name@Description
0@BOTLEFT@text aligned to bottom left
1@BOTRIGHT@text aligned to bottom right
2@CENTCENT@center object
3@VECTOR@vector
4@ARC@arc
5@CURVE@curve
6@POLYGON@polygon
7@BSPLINE@b-spline
8@BEZIER@B\['e]zier
10@TOPLEFT@text aligned to top left
11@TOPCENT@text aligned to top center
12@TOPRIGHT@text aligned to top right
13@CENTLEFT@text aligned to center left
14@CENTRIGHT@text aligned to center right
15@BOTCENT@text aligned to bottom center
.TE
.
.
.IP \[bu]
Each line after the object type specifies a point used to display the
element.
.
It contains an
.I x
and a
.I y
coordinate in floating-point format,
separated by spaces.
.
The list of points is terminated by a line containing the string
.RB \[lq] "\-1.0 \-1.0" \[rq]
(AED) or a single asterisk,
.RB \[lq] * \[rq]
(Sun/X11).
.
.
.IP \[bu]
After the points comes a line containing two decimal values,
giving the brush and size for the element.
.
The brush determines the style in which things are drawn.
.
For vectors,
arcs,
and curves there are six valid brush values.
.
.
.IP
.TS
center, tab(@);
nB l.
1@thin dotted lines
2@thin dot-dashed lines
3@thick solid lines
4@thin dashed lines
5@thin solid lines
6@medium solid lines
.TE
.
.
.IP
For polygons,
0
is also valid:
it specifies an invisible border.
.
For text,
the brush selects a font as follows.
.
.
.IP
.TS
center, tab(@);
nB l.
1@roman (R font in \f[I]@g@troff\f[])
2@italics (I font in \f[I]@g@troff\f[])
3@bold (B font in \f[I]@g@troff\f[])
4@special (S font in \f[I]@g@troff\f[])
.TE
.
.
.IP
If you're using
.I @g@grn
to run your pictures through
.IR groff ,
the font is really just a starting font.
.
The text string can contain formatting sequences like
\[lq]\[rs]fI\[rq]
or
\[lq]\[rs]d\[rq]
which may change the font
(as well as do many other things).
.
For text,
the size field is a decimal value between 1 and 4.
.
It selects the size of the font in which the text will be drawn.
.
For polygons,
this size field is interpreted as a stipple number to fill the polygon
with.
.
The number is used to index into a stipple font at print time.
.
.
.IP \[bu]
The last line of each element contains a decimal number and a string of
characters,
separated by a single space.
.
The number is a count of the number of characters in the string.
.
This information is used only for text elements,
and contains the text string.
.
There can be spaces inside the text.
.
For arcs,
curves,
and vectors,
the character count is zero
.RB ( 0 ),
followed by exactly one space before the newline.
.
.
.\" ====================================================================
.SS Coordinates
.\" ====================================================================
.
.I gremlin
was designed for AED terminals,
and its coordinates reflect the AED coordinate space.
.
For vertical pictures,
.IR x \~values
range 116 to 511,
and
.IR y \~values
from 0 to 483.
.
For horizontal pictures,
.IR x \~values
range from 0 to 511,
and
.IR y \~values
from 0 to 367.
.
Although you needn't absolutely stick to this range,
you'll get better results if you at least stay in this vicinity.
.
Also,
point lists are terminated by a point of
(\-1,
\-1),
so you shouldn't ever use negative coordinates.
.
.I gremlin
writes out coordinates using the
.MR printf 3
format \[lq]%f1.2\[rq];
it's probably a good idea to use the same format if you want to modify
the
.I @g@grn
code.
.
.
.\" ====================================================================
.SS "Sun/X11 coordinates"
.\" ====================================================================
.
There is no restriction on the range of coordinates used to create
objects in the Sun/X11 version of
.IR gremlin .
.
However,
files with negative coordinates
.I will
cause problems if displayed on the AED.
.
.
.\" ====================================================================
.SH Options
.\" ====================================================================
.
.B \-?\&
and
.B \-\-help
display a usage message,
while
.B \-v
and
.B \%\-\-version
show version information;
all exit afterward.
.
.
.TP 8.125n \" "-F dir" + 2n + hand-tuned for PDF
.B \-C
Recognize
.B .GS
and
.B .GE
(and
.BR .GF )
even when followed by a character other than space or newline.
.
.
.TP
.BI \-F\~ dir
Search
.I dir
for subdirectories
.IR dev name
.RI ( name
is the name of the output driver)
for the
.I DESC
file before the default font directories
.IR @LOCALFONTDIR@ ,
.IR @FONTDIR@ ,
and
.IR @LEGACYFONTDIR@ .
.
.
.TP
.BI \-M\~ dir
Prepend
.I dir
to the search path for
.I gremlin
files.
.
The default search path is the current directory,
the home directory,
.if !'@COMPATIBILITY_WRAPPERS@'no' .IR @SYSTEMMACRODIR@ ,
.IR @LOCALMACRODIR@ ,
and
.IR @MACRODIR@ ,
in that order.
.\".
.\".
.\".TP
.\".B \-s
.\"This switch causes the picture to be traversed twice:
.\"The first time,
.\"only the interiors of filled polygons
.\"(as borderless polygons)
.\"are printed.
.\".
.\"The second time,
.\"the outline is printed as a series of line segments.
.\".
.\"This way,
.\"postprocessors that overwrite rather than merge picture elements
.\"(such as PostScript)
.\"can still have text and graphics on a shaded background.
.
.
.TP
.BI \-T\~ dev
Prepare device output using output driver
.IR dev .
.
The default is
.BR @DEFAULT_DEVICE@ .
.
See
.MR groff @MAN1EXT@
for a list of valid devices.
.
.
.\" ====================================================================
.SH "Exit status"
.\" ====================================================================
.
.I @g@grn
exits with
.RB status\~ 0
on successful operation,
.RB status\~ 2
if the program cannot interpret its command-line arguments,
and
.RB status\~ 1
if it encounters an error during operation.
.
.
.\" ====================================================================
.SH Files
.\" ====================================================================
.
.TP
.IR @FONTDIR@/\:\%dev name /\:DESC
describes the output device
.IR name .
.
.
.\" ====================================================================
.SH Authors
.\" ====================================================================
.
David Slattengren and Barry Roitblat wrote the original Berkeley
.IR grn .
.
Daniel Senderowicz and
.MT wl@\:gnu\:.org
Werner Lemberg
.ME
modified it for
.IR groff .
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.MR gremlin 1 ,
.MR groff @MAN1EXT@ ,
.MR @g@pic @MAN1EXT@ ,
.MR ideal 1
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_grn_1_man_C]
.do rr *groff_grn_1_man_C
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
