.TH addftinfo @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
addftinfo \- add font metrics to
.I troff
fonts for use with
.I groff
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1989-2025 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_addftinfo_1_man_C \n[.cp]
.cp 0
.
.\" Define fallback for groff 1.23's MR macro if the system lacks it.
.nr do-fallback 0
.if !\n(.f           .nr do-fallback 1 \" mandoc
.if  \n(.g .if !d MR .nr do-fallback 1 \" older groff
.if !\n(.g           .nr do-fallback 1 \" non-groff *roff
.if \n[do-fallback]  \{\
.  de MR
.    ie \\n(.$=1 \
.      I \%\\$1
.    el \
.      IR \%\\$1 (\\$2)\\$3
.  .
.\}
.rr do-fallback
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY addftinfo
.RB [ \-asc\-height\~\c
.IR n ]
.RB [ \-body\-depth\~\c
.IR n ]
.RB [ \-body\-height\~\c
.IR n ]
.RB [ \-cap\-height\~\c
.IR n ]
.RB [ \-comma\-depth\~\c
.IR n ]
.RB [ \-desc\-depth\~\c
.IR n ]
.RB [ \-fig\-height\~\c
.IR n ]
.RB [ \-x\-height\~\c
.IR n ]
.I resolution
.I unit-width
.I font
.YS
.
.
.P
.SY addftinfo
.B \-\-help
.YS
.
.
.P
.SY addftinfo
.B \-v
.YS
.
.SY addftinfo
.B \%\-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
.I addftinfo
reads an
.RI AT&T \~troff
font description file
.IR font ,
adds further font metric information required by
.\" We need the "GNU" below because the @g@ prefix might be empty.
GNU
.MR @g@troff @MAN1EXT@ ,
and writes the combined result to the standard output stream.
.
The information added is derived from the font's existing parameters and
assumptions about traditional
.I troff
names for characters.
.
Among the font metrics added are the heights and depths of characters
(how far each extends vertically above and below the baseline).
.
The
.I resolution
and
.I unit-width
arguments should be the same as the corresponding parameters in the
.I DESC
file.
.
.I font
is the name of the file describing the font;
if
.I font
ends with
.RB \[lq] I \[rq],
the font is assumed to be oblique
(or italic).
.
.
.\" ====================================================================
.SH Options
.\" ====================================================================
.
.B \-\-help
displays a usage message,
while
.B \-v
and
.B \%\-\-version
show version information;
all exit afterward.
.
.
.P
All other options change parameters that are used to derive the heights
and depths.
.
Like the existing quantities in the font description file,
each
.RI value\~ n
is in
.I "scaled points,"
.RI inches/ resolution
for a font whose type size is
.IR unit-width ;
see
.MR groff_font @MAN5EXT@ .
.
.
.TP
.BI \-asc\-height \~n
height of characters with ascenders,
such as \[lq]b\[rq],
\[lq]d\[rq],
or \[lq]l\[rq]
.
.
.TP
.BI \-body\-depth \~n
depth of characters such as parentheses
.
.
.TP
.BI \-body\-height \~n
height of characters such as parentheses
.
.
.TP
.BI \-cap\-height \~n
height of uppercase letters such as \[lq]A\[rq]
.
.
.TP
.BI \-comma\-depth \~n
depth of a comma
.
.
.TP
.BI \-desc\-depth \~n
depth of characters with descenders,
such as \[lq]p\[rq],
\[lq]q\[rq],
or \[lq]y\[rq]
.
.
.TP
.B \-fig\-height
height of figures (numerals)
.
.
.TP
.BI \-x\-height \~n
height of lowercase letters without ascenders such as \[lq]x\[rq]
.
.
.P
.I addftinfo
makes no attempt to use the specified parameters to infer unspecified
parameters.
.
If a parameter is not specified,
the default will be used.
.
The defaults are chosen to produce reasonable values for a Times font.
.
.
.\" ====================================================================
.SH "Exit status"
.\" ====================================================================
.
.I \%addftinfo
exits with
.RB status\~ 0
on successful operation,
and
.RB status\~ 2
if the program cannot interpret its command-line arguments.
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.MR groff_font @MAN5EXT@ ,
.MR groff @MAN1EXT@ ,
.MR groff_char @MAN7EXT@
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_addftinfo_1_man_C]
.do rr *groff_addftinfo_1_man_C
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
