.TH grohtml @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
grohtml, post\-grohtml, pre\-grohtml \-
.I groff
output driver for HTML
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1999-2024 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_grohtml_1_man_C \n[.cp]
.cp 0
.
.\" Define fallback for groff 1.23's MR macro if the system lacks it.
.nr do-fallback 0
.if !\n(.f           .nr do-fallback 1 \" mandoc
.if  \n(.g .if !d MR .nr do-fallback 1 \" older groff
.if !\n(.g           .nr do-fallback 1 \" non-groff *roff
.if \n[do-fallback]  \{\
.  de MR
.    ie \\n(.$=1 \
.      I \%\\$1
.    el \
.      IR \%\\$1 (\\$2)\\$3
.  .
.\}
.rr do-fallback
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY pre\-grohtml
.RB [ \-epV ]
.RB [ \-a\~\c
.IR anti-aliasing-text-bits ]
.RB [ \-D\~\c
.IR image-directory ]
.RB [ \-F\~\c
.IR font-directory ]
.RB [ \-g\~\c
.IR anti-aliasing-graphic-bits ]
.RB [ \-i\~\c
.IR resolution ]
.RB [ \-I\~\c
.IR image-stem ]
.RB [ \-o\~\c
.IR image-vertical-offset ]
.RB [ \-x\~\c
.IR  html-dialect ]
.I troff-command
.I troff-argument
\&.\|.\|.
.YS
.
.
.P
.SY pre\-grohtml
.B \-\-help
.YS
.
.
.P
.SY pre\-grohtml
.B \-v
.YS
.
.SY pre\-grohtml
.B \%\-\-version
.YS
.
.
.P
.SY post\-grohtml
.RB [ \-bCGhlnrVy ]
.RB [ \-F\~\c
.IR font-directory ]
.RB [ \-j\~\c
.IR output-stem ]
.RB [ \-k\~\c
.IR encoding ]
.RB [ \-s\~\c
.IR base-point-size ]
.RB [ \-S\~\c
.IR heading-level ]
.RB [ \-x\~\c
.IR html-dialect ]
.RI [ file\~ .\|.\|.]
.YS
.
.
.P
.SY post\-grohtml
.B \-\-help
.YS
.
.
.P
.SY post\-grohtml
.B \-v
.YS
.
.SY post\-grohtml
.B \%\-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
The GNU
.I roff
system's HTML support consists of a preprocessor,
.IR \%pre\-grohtml ,
and an output driver,
.IR \%post\-grohtml ;
together,
they translate
.MR roff @MAN7EXT@
documents to HTML.
.
Because a preprocessor is (uniquely) required for this output driver,
users should invoke
.I \%grohtml
via the
.MR groff @MAN1EXT@
command with the
.B \-Thtml
or
.B \%\-Txhtml
options.
.
(In this installation,
.B @DEFAULT_DEVICE@
is the default output device.)
.
Use
.IR groff 's
.B \-P
option to pass any options shown above to
.IR \%grohtml .
.
If no operands are given,
or if
.I file
is
.RB \[lq] \- \[rq],
.I \%grohtml
reads the standard input stream.
.
It writes to the standard output stream.
.
.
.P
.I \%grohtml
invokes
.I groff
twice.
.
In the first pass,
the preprocessor
.I \%pre\-grohtml
renders
pictures,
equations,
and tables as images in PostScript format using the
.B ps
output device.
.
In the second pass,
the output driver
.I \%post\-grohtml
translates the output of
.MR @g@troff @MAN1EXT@
to HTML.
.
.
.P
.I \%grohtml
writes \%UTF-8-\:encoded output
(but see the
.B \-k
option)
and produces HTML character references
for most non-composite,
non-basic Latin
Unicode characters.
.\" XXX: Exception: degree sign (U+00B0).  Why?
.
In spite of this,
.I groff
may issue warnings about unknown special characters if they can't be
found during the first pass.
.
You can ignore these warnings unless the special characters appear
inside a table or equation.
.\" XXX: or pic(1) description?
.
.
.\" ====================================================================
.SS Typefaces
.\" ====================================================================
.
.I \%grohtml
supports the standard four styles:
.B R
(roman),
.B I
.RI ( italic ),
.B B
.RB ( bold ),
and
.B BI
(\f[BI]bold-italic\f[]).
.
Fonts are grouped into families
.B T
and
.B C
having members in each style.
.
.
.RS
.TP
.B TR
Times roman
.
.TQ
.B TI
Times italic
.
.TQ
.B TB
Times bold
.
.TQ
.B TBI
Times bold-italic
.
.TQ
.B CR
Courier roman
.
.TQ
.B CI
Courier italic
.
.TQ
.B CB
Courier bold
.
.TQ
.B CBI
Courier bold-italic
.RE
.
.
.P
A special font,
.BR S ,
is also provided to accommodate
.I roff
documents that expect it to always be available.
.
.
.P
.I \%grohtml
furthermore supports a naming scheme for East Asian typefaces
shared with
.MR gropdf @MAN1EXT@ ,
.MR grops @MAN1EXT@ ,
and
.MR grotty @MAN1EXT@ .
.
.
.RS
.TP
.B CSH
Simplified Chinese,
Hei style
.
.TQ
.B CSS
Simplified Chinese,
Song style
.
.TQ
.B CTH
Traditional Chinese,
Hei style
.
.TQ
.B CTS
Traditional Chinese,
Song style
.
.TQ
.B JPG
Japanese,
Gothic style
.
.TQ
.B JPM
Japanese,
Mincho style
.
.TQ
.B KOG
Korean,
Gothic style
.
.TQ
.B KOM
Korean,
Mincho style
.RE
.
.
.\" ====================================================================
.SS "Font description files"
.\" ====================================================================
.
The font description files used with
.I \%grohtml
expose the same glyph repertoire in their
.B charset
sections.
.
See
.MR groff_font @MAN5EXT@ .
.
.
.\" ====================================================================
.SS Dependencies
.\" ====================================================================
.
.I \%pre\-grohtml
generates an image whenever an
.I @g@eqn
equation,
.I @g@tbl
table,
or
.I @g@pic
picture is encountered in the input.
.
.I \%grohtml
therefore may run several commands as part of its operation.
.
These include the \%Netpbm tools
.IR \%pamcut ,
.IR \%pnmcrop ,
and
.IR \%pnmtopng ,
as well as
\%Ghostscript's
.I \%gs
and
.IR \%ps2ps .
.
.
.\" ====================================================================
.SH Options
.\" ====================================================================
.
.B \-\-help
displays a usage message,
while
.B \-v
and
.B \%\-\-version
show version information;
all exit afterward.
.
.
.TP
.BI \-a \~anti-aliasing-text-bits
Number of bits of antialiasing information to be used by text when
generating PNG images.
.
The default
.RB is\~ 4
but
.BR 0 ,
.BR 1 ,
and
.B 2
are also valid.
.
Your system's version of
.I gs
must support the
.B \%\-dTextAlphaBits
option in order to exploit antialiasing.
.\" XXX: How antiquated are the ones that don't?  Get rid of this?
.
A value
.RB of\~ 0
stops
.I \%grohtml
from issuing antialiasing commands to
.IR gs .
.
.
.TP
.B \-b
Initialize the background color to white.
.
.
.TP
.B \-C
Suppress output of \[lq]CreationDate:\[rq] HTML comment.
.
.
.TP
.BI \-D \~image-directory
Instruct
.I \%grohtml
to place all image files into directory
.IR image-directory .
.
.
.TP
.B \-e
Direct
.I @g@eqn
to produce MathML.
.
.
.IP
This option should not be manually specified;
it is synthesized by
.I groff
depending on whether it was given the
.B \-Thtml
or
.B \%\-Txhtml
option.
.
.
.TP
.BI \-F \~font-directory
Prepend directory
.RI font-directory /dev name
to the search path for font and device description files;
.I name
is the name of the device,
usually
.BR html .
.
.
.TP
.BI \-g \~anti-aliasing-graphic-bits
Number of bits of antialiasing information to be used by graphics when
generating PNG images.
.
The default
.RB is\~ 4
but
.BR 0 ,
.BR 1 ,
and
.B 2
are also valid.
.
Your system's version of
.I gs
must support the
.B \%\-dGraphicAlphaBits
option in order to exploit antialiasing.
.\" XXX: How antiquated are the ones that don't?  Get rid of this?
.
A value
.RB of\~ 0
stops
.I \%grohtml
from issuing antialiasing commands to
.IR gs .
.
.
.TP
.B \-G
Suppress output of \[lq]Creator:\[rq] HTML comment.
.
.
.TP
.B \-h
Generate section headings by using HTML
.B B
elements and increasing the font size,
rather than HTML
.B H
elements.
.
.
.TP
.BI \-i \~resolution
Set the image resolution in pixels per inch;
the default
.RB is\~ 100 .
.
.
.TP
.BI \-I \~image-stem
Determine the image file name stem.
.
If omitted,
.I \%grohtml
uses
.IR \%grohtml\- XXXXX
(where
.I XXXXX
is the process ID).
.
A dash is appended to the stem to separate it from the following image
number.
.
.
.TP
.BI \-j \~output-stem
Instruct
.I \%grohtml
to split the HTML output into multiple files.
.
Output is written to a new file at each section heading
(but see option
.B \-S
below)
named
.IR output-stem\- n .html .
.
.
.br
.ne 4v
.TP
.BI \-k \~encoding
Select the character encoding used in the generated document,
affecting the declared encoding in the preamble
and the form of character entity references.
.
.\" XXX: Don't present "mixed" until we know what it's for.
Valid values are \[lq]ASCII\[rq] and \[lq]UTF\-8\[rq].
.
The default is \[lq]UTF-8\[rq].
.
.
.TP
.B \-l
Turn off the production of automatic section links at the top of the
document.
.
.
.TP
.B \-n
Generate simple heading anchors whenever a section/number heading is
found.
.
Without the option the anchor value is the textual heading.
.
This can cause problems when a heading contains a \[lq]?\[rq] on older
versions of some browsers.
.
This feature is automatically enabled if a heading contains an image.
.
.
.TP
.BI \-o \~image-vertical-offset
Specify the vertical offset of images in points.
.
.
.TP
.B \-p
Display page rendering progress to the standard error stream.
.
.I \%grohtml
displays a page number only when an image is required.
.
.
.TP
.B \-r
Turn off the automatic header and footer line
(HTML rule).
.
.
.TP
.BI \-s \~base-type-size
Set the document's base type size in points.
.
When this size is used in the source,
it corresponds to the HTML base type size.
.
Every increase of two points in the source will produce a
.RB \[lq] big \[rq]
element,
and conversely when a decrease of two points is seen,
a
.RB \[lq] small \[rq]
element is emitted.
.
.
.TP
.BI \-S \~heading-level
When splitting HTML output
(see option
.B \-j
above),
split at each nested heading level defined by
.IR heading-level ,
or higher).
.
The default is
.BR 1 .
.
.
.TP
.B \-V
Create an XHTML or HTML validator button at the bottom of each page of
the document.
.
.
.TP
.BI \-x \~html-dialect
Select HTML dialect.
.
Currently,
.I html-dialect
should be either the
.RB digit\~ 4
or the
.RB letter\~ x ,
which indicates whether
.I \%grohtml
should generate HTML\~4 or XHTML,
respectively.
.
.
.IP
This option should not be manually specified;
it is synthesized by
.I groff
depending on whether it was given the
.B \-Thtml
or
.B \%\-Txhtml
option.
.
.
.TP
.B \-y
Produce a right-aligned
.I groff
signature at the end of the document
(only if
.B \-V
is also specified).
.
.
.\" ====================================================================
.SH "Exit status"
.\" ====================================================================
.
.I \%pre\-grohtml
and
.I \%post\-grohtml
each exit with
.RB status\~ 0
on successful operation,
.RB status\~ 2
if the program cannot interpret its command-line arguments,
and
.RB status\~ 1
if it encounters an error during operation.
.
.
.\" ====================================================================
.SH Environment
.\" ====================================================================
.
.TP
.I GROFF_FONT_PATH
lists directories in which to search for
.IR devhtml ,
.IR grohtml 's
directory of device and font description files.
.
See
.MR @g@troff @MAN1EXT@
and
.MR groff_font @MAN5EXT@ .
.
.
.TP
.I SOURCE_DATE_EPOCH
A timestamp
(expressed as seconds since the Unix epoch)
to use as the output creation timestamp in place of the current time.
.
The time is converted to human-readable form using
.MR gmtime 3
and
.MR asctime 3 ,
and recorded in an HTML comment.
.
.
.TP
.I TZ
The time zone to use when converting the current time to human-readable form;
see
.MR tzset 3 .
If
.I SOURCE_DATE_EPOCH
is used, it is always converted to human-readable form using UTC.
.
.
.\" ====================================================================
.SH Files
.\" ====================================================================
.
.TP
.I @FONTDIR@/\:\%devhtml/\:DESC
describes the
.B html
output device.
.
.
.TP
.IR @FONTDIR@/\:\%devhtml/ F
describes the font known
.RI as\~ F
on device
.BR html .
.
.
.TP
.I @MACRODIR@/\:html\:.tmac
defines font mappings,
special characters,
and colors for use with the
.B html
output device.
.
It is automatically loaded by
.I \%troffrc
when either of the
.B html
or
.B xhtml
output devices is selected.
.
.
.TP
.I @MACRODIR@/\:html\-end\:.tmac
finalizes setup of the
.B html
output device.
.
It is automatically loaded by
.I \%troffrc\-end
when either of the
.B html
or
.B xhtml
output devices is selected.
.
.
.P
.I \%grohtml
uses temporary files.
.
See
.MR groff @MAN1EXT@
for details about where such files are created.
.
.
.\" ====================================================================
.SH Bugs
.\" ====================================================================
.
.I \%grohtml
is still beta code.
.
.
.PP
.I \%grohtml
does not truly support hyphenation,
but you can fool it into hyphenating long input lines,
which can appear in HTML output with a hyphenated word followed by a
space but no line break.
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.\" IR afmtodit (@MAN1EXT@),
.MR groff @MAN1EXT@ ,
.MR @g@troff @MAN1EXT@ ,
.\" IR psbb (1), \" XXX: what is this?
.\" IR groff_out (@MAN5EXT@),
.\" IR groff_char (@MAN7EXT@),
.MR groff_font @MAN5EXT@
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_grohtml_1_man_C]
.do rr *groff_grohtml_1_man_C
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
